﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace Chapter4__Neapolitan_
{
    class nodetype
    {
        public char symbol;
        public int frequency;
        public nodetype left;
        public nodetype right;

        public nodetype(char sym, int freq, nodetype lef, nodetype righ)
        {
            symbol = sym;
            frequency = freq;
            left = lef;
            right = righ;
        }
    }
    class Edge
    {
        public int Weight;
        public int FirstVertex;
        public int SecondVertex;
        public Edge(int weight, int vert1st, int vert2nd)
        {
            Weight = weight;
            FirstVertex = vert1st;
            SecondVertex = vert2nd;
        }
        public static void NonDec_Sort(Edge[] edges)
        {
            for (int i = 1; i < edges.Length; i++)
            {
                for (int j = 0; j < edges.Length - i; j++)
                {
                    if (edges[j].Weight > edges[j + 1].Weight)
                    {
                        Edge temp = edges[j];
                        edges[j] = edges[j + 1];
                        edges[j + 1] = temp;
                    }
                }
            }
        }
    }
    class Program
    {
        #region Question 6
        static bool Prim_IsConnective(int n, int[,] W, bool[,] Result)
        {
            int Infinity = 1000000;
            int[] nearest = new int[n + 1];
            int[] distance = new int[n + 1];
            bool Check = true;
            for (int i = 2; i <= n; i++)
            {
                nearest[i] = 1;
                distance[i] = W[1, i];
            }
            distance[1] = -1;
            for (int i = 1; i <= n - 1; i++)
            {
                int min = Infinity;
                int vnear = 0;
                for (int j = 1; j <= n; j++)
                {
                    if (distance[j] >= 0 && distance[j] < min)
                    {
                        min = distance[j];
                        vnear = j;
                    }
                }
                if (distance[vnear] < Infinity && vnear != 0)
                    Result[nearest[vnear], vnear] = true;
                else
                    Check = false;
                for (int j = 2; j <= n; j++)
                {
                    if (W[j, vnear] < distance[j])
                    {
                        nearest[j] = vnear;
                        distance[j] = W[j, vnear];
                    }
                }
                distance[vnear] = -1;
            }
            return Check;
        }
        #endregion
        #region Question 15
        static void Dijkstra_withLength(int n, int[,] W, bool[,] Result, int src, out int[] Len)
        {
            int Infinity = 1000000;
            int[] touch = new int[n + 1];
            int[] length = new int[n + 1];
            Len = new int[n + 1];
            for (int i = 1; i <= n; i++)
            {
                touch[i] = src;
                length[i] = W[src, i];
            }
            length[src] = -1;
            for (int i = 1; i <= n - 1; i++)
            {
                //Console.WriteLine("\ntouch");
                //for (int j = 1; j < touch.Length; j++)
                //{
                //    if (j == src)
                //        continue;
                //    Console.Write(touch[j] + "\t");
                //}
                //Console.WriteLine("\nlength");
                //for (int j = 1; j < length.Length; j++)
                //{
                //    if (j == src)
                //        continue;
                //    Console.Write(length[j] + "\t");
                //}
                //Console.WriteLine();
                int min = Infinity;
                int best = 0;
                for (int j = 1; j <= n; j++)
                {
                    if (length[j] >= 0 && length[j] < min)
                    {
                        min = length[j];
                        best = j;
                    }
                }
                if (length[best] < Infinity && best != 0)
                    Result[touch[best], best] = true;
                for (int j = 1; j <= n; j++)
                {
                    if (length[best] + W[best, j] < length[j])
                    {
                        touch[j] = best;
                        length[j] = length[best] + W[best, j];
                    }
                }
                Len[best] = length[best];
                length[best] = -1;
            }
        }
        #endregion
        #region Question 21
        static void Schedule_MultyProc(int[] Job, int[] Times, int ProcessorsCnt, out int[,] Result)
        {
            Result = new int[ProcessorsCnt, (Job.Length / ProcessorsCnt) + 1];
            int j = 0, k = 0;
            //NonDec_Sort(Job, Times); // Sort Jobs base on their times
            for (int i = 0; i < Job.Length; i++)
            {
                Result[j, k] = Job[i];
                j++;
                if (j == ProcessorsCnt)
                {
                    j = 0;
                    k++;
                }
            }
        }
        #endregion
        #region Question 25
        static void StoreFiles(int[] length, float[] probability, out int[] Result)
        {
            Result = new int[length.Length];
            for (int i = 0; i < Result.Length; i++)
            {
                Result[i] = i + 1;
            }
            float[] ProbOnLen = new float[length.Length];
            for (int i = 0; i < ProbOnLen.Length; i++)
            {
                ProbOnLen[i] = probability[i] / length[i];
            }
            // NonInc_Sort(Result, ProbOnLen) // Sort files base on their Prob/Len value
            for (int i = 1; i < Result.Length; i++)
            {
                for (int j = 0; j < Result.Length - i; j++)
                {
                    if (ProbOnLen[j] < ProbOnLen[j + 1])
                    {
                        float tmpF = ProbOnLen[j];
                        ProbOnLen[j] = ProbOnLen[j + 1];
                        ProbOnLen[j + 1] = tmpF;
                        int tmpI = Result[j];
                        Result[j] = Result[j + 1];
                        Result[j + 1] = tmpI;
                    }
                }
            }
        }

        #endregion
        #region Question 34
        struct Code
        {
            public char symbol;
            public string code;
        }
        static void PrefixCodes(nodetype root, ref string currCode, List<Code> result)
        {
            if (root.left == null)
            {
                Code newCode;
                newCode.symbol = root.symbol;
                newCode.code = currCode;
                result.Add(newCode);
            }
            else
            {
                currCode += "0";
                PrefixCodes(root.left, ref currCode, result);
                currCode = currCode.Remove(currCode.Length - 1);
                currCode += "1";
                PrefixCodes(root.right, ref currCode, result);
                currCode = currCode.Remove(currCode.Length - 1);
            }
        }

        #endregion
        #region Question 35
        static int Dynamic_Knapsack(int[] p, int[] w, int n, int W)
        {
            int[,] P = new int[n + 1, W + 1];
            for (int i = 0; i <= n; i++)
            {
                P[i, 0] = 0;
            }
            for (int i = 0; i <= W; i++)
            {
                P[0, i] = 0;
            }
            for (int i = 1; i <= n; i++)
            {
                for (int j = 1; j <= W; j++)
                {
                    if (w[i] <= j && (p[i] + P[i - 1, j - w[i]]) > P[i - 1, j])
                    {
                        P[i, j] = p[i] + P[i - 1, j - w[i]];
                    }
                    else
                    {
                        P[i, j] = P[i - 1, j];
                    }
                }
            }
            return P[n, W];
        }
        #endregion
        #region Question 37 (Greedy -> Non Optimal)
        static void JobAssignment(int n, int[,] C, out Edge[] Result)
        {
            Result = new Edge[n];
            Edge[] edges = new Edge[n * n];
            bool[] isSelectedPerson = new bool[n];
            bool[] isSelectedJob = new bool[n];
            for (int i = 0; i < n; i++)
            {
                for (int j = 0; j < n; j++)
                {
                    int index = i * n + j;
                    edges[index] = new Edge(C[i, j], i, j);
                    // edges[index].Weight = C[i, j] , edges[index].FirstVertex = i , edges[index].SecondVertex = j
                }
            }
            Edge.NonDec_Sort(edges);
            for (int i = 0, j = 0; i < (n * n); i++)
            {
                int PersonIndex = edges[i].FirstVertex;
                int JobIndex = edges[i].SecondVertex;
                if (!isSelectedJob[JobIndex] && !isSelectedPerson[PersonIndex])
                {
                    Result[j] = edges[i];
                    j++;
                    isSelectedPerson[PersonIndex] = true;
                    isSelectedJob[JobIndex] = true;
                }
            }
        }
        #endregion
        #region Question 46
        static void TSP_Greedy(int n, int[,] Weight, out int[] Result)
        {
            int Infinity = 1000000;
            Result = new int[n];
            bool[] isSelectedVertex = new bool[n];
            int currentVertex = 0;
            int nextVertex = -1;
            int MinWeight;
            for (int i = 0; i < n; i++)
            {
                MinWeight = Infinity;
                isSelectedVertex[currentVertex] = true;
                Result[i] = currentVertex;
                for (int j = 1; j < n; j++)
                {
                    if (!isSelectedVertex[j] && Weight[currentVertex, j] < MinWeight)
                    {
                        MinWeight = Weight[currentVertex, j];
                        nextVertex = j;
                    }
                }
                currentVertex = nextVertex;
            }
        }
        #endregion
        static void Main(string[] args)
        {
            int Inf = 1000000;
            Console.WriteLine("-------------------------------------------------------------// 6");
            int[,] mat1 = {
                         {  0,       0,      0,       0,       0,       0,       0,       0,       0,       0,        0   },
                         {  0,       0,      32,      Inf,     17,      Inf,     Inf,     Inf,     Inf,     Inf,      Inf },
                         {  0,       32,     0,       Inf,     Inf,     45,      Inf,     Inf,     Inf,     Inf,      Inf },
                         {  0,       Inf,    Inf,     0,       18,      Inf,     Inf,     5,       Inf,     Inf,      Inf },
                         {  0,       17,     Inf,     18,      0,       10,      Inf,     Inf,     3,       Inf,      Inf },
                         {  0,       Inf,    45,      Inf,     10,      0,       28,      Inf,     Inf,     25,       Inf },
                         {  0,       Inf,    Inf,     Inf,     Inf,     28,      0,       Inf,     Inf,     Inf,      6   },
                         {  0,       Inf,    Inf,     5,       Inf,     Inf,     Inf,     0,       59,      Inf,      Inf },
                         {  0,       Inf,    Inf,     Inf,     3,       Inf,     Inf,     59,      0,       4,        Inf },
                         {  0,       Inf,    Inf,     Inf,     Inf,     25,      Inf,     Inf,     4,       0,        12  },
                         {  0,       Inf,    Inf,     Inf,     Inf,     Inf,     6,       Inf,     Inf,     12,       0   }
                         };
            bool[,] res = new bool[mat1.GetLength(0), mat1.GetLength(0)];
            Console.WriteLine(Prim_IsConnective(mat1.GetLength(0) - 1, mat1, res));
            //for (int i = 1; i < res.GetLength(0); i++)
            //{
            //    for (int j = 1; j < res.GetLength(1); j++)
            //    {
            //        Console.Write(res[i, j] + "\t");
            //    }
            //    Console.WriteLine();
            //}
            Console.WriteLine("\n-------------------------------------------------------------// 15");
            int[] len;
            int[,] mat2 = {
                         {  0,       0,      0,       0,       0,       0,       0   },
                         {  0,       0,      Inf,     72,      50,      90,      35  },
                         {  0,       Inf,    0,       71,      70,      73,      75  },
                         {  0,       72,     71,      0,       Inf,     77,      90  },
                         {  0,       50,     70,      Inf,     0,       60,      40  },
                         {  0,       90,     73,      77,      60,      0,       80  },
                         {  0,       73,     75,      90,      40,      80,      0   },
                         };
            Dijkstra_withLength(mat2.GetLength(0) - 1, mat2, res, 5, out len);
            for (int i = 1; i < len.Length; i++)
                Console.Write(len[i] + " ");
            Console.WriteLine("\n-------------------------------------------------------------// 21");
            int[] arr = { 1, 2, 3, 4, 5 };
            int[,] res2;
            Schedule_MultyProc(arr, arr, 2, out res2);
            print(res2);
            Console.WriteLine("\n-------------------------------------------------------------// 25");
            float[] probs = { 0.2f, 0.6f, 0.1f, 0.8f, 0.5f, 0.7f };
            int[] length = { 21, 32, 12, 14, 17, 25 };
            int[] Res;
            StoreFiles(length, probs, out Res);
            print(Res);
            Console.WriteLine("\n-------------------------------------------------------------// 34");
            nodetype root = new nodetype('\0', 85, new nodetype('\0', 33, new nodetype('a', 16, null, null), new nodetype('d', 17, null, null)),
                new nodetype('\0', 52, new nodetype('f', 25, null, null), new nodetype('\0', 27, new nodetype('c', 12, null, null),
                    new nodetype('\0', 15, new nodetype('b', 5, null, null), new nodetype('e', 10, null, null)))));
            // root is tree of figure 4-10 (b) in chapter 4 neapolitan
            string currCode = string.Empty;
            List<Code> result = new List<Code>();
            PrefixCodes(root, ref currCode, result);
            for (int i = 0; i < result.Count; i++)
            {
                Console.Write(result[i].symbol + ":" + result[i].code + "\t");
            }
            Console.WriteLine("\n-------------------------------------------------------------// 35");
            Console.WriteLine("Optimal result : " + Dynamic_Knapsack(new int[] { 0, 50, 60, 140 }, new int[] { 0, 5, 10, 20 }, 3, 30));
            Console.WriteLine("\n-------------------------------------------------------------// 37");
            Edge[] Result;
            int[,] C = {
                       {    2,  1,  4,  5   },
                       {    3,  2,  3,  4   },
                       {    1,  4,  3,  3   },
                       {    3,  1,  4,  2   },
                       };
            JobAssignment(C.GetLength(0), C, out Result);
            for (int i = 0; i < Result.Length; i++)
            {
                Console.Write((Result[i].FirstVertex + 1) + "->" + (Result[i].SecondVertex + 1) + "\t");
            }
            Console.WriteLine("\n-------------------------------------------------------------// 46");
            int[,] Weight = {
                            {    0,  2,  4,  3   },
                            {    3,  0,  8,  10   },
                            {    6,  4,  0,  4   },
                            {    5,  5,  4,  0   },
                            };
            int[] tour;
            TSP_Greedy(Weight.GetLength(0), Weight, out tour);
            for (int i = 0; i < tour.Length; i++)
            {
                Console.Write((tour[i] + 1) + "->");
            }
            Console.Write(tour[0] + 1);
            Console.WriteLine("\n-------------------------------------------------------------// 46");
            Console.ReadKey();
        }
        #region Print
        static void print(bool[,] array)
        {
            for (int i = 0; i < array.GetLength(0); i++)
            {
                Console.WriteLine("\n");
                for (int j = 0; j < array.GetLength(1); j++)
                    Console.Write((array[i, j] ? 1 : 0) + "  ");
            }
            Console.WriteLine();
        }
        static void print(int[,] array)
        {
            for (int i = 0; i < array.GetLength(0); i++)
            {
                Console.WriteLine("\n");
                for (int j = 0; j < array.GetLength(1); j++)
                    Console.Write(array[i, j] + "  ");
            }
            Console.WriteLine();
        }
        static void print(int[] array)
        {
            for (int i = 0; i < array.GetLength(0); i++)
            {
                Console.Write(array[i] + "  ");
            }
            Console.WriteLine();
        }
        #endregion
    }
}
